using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgOrderReportCriteria
	/// </summary>
	public class DlgOrderReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.OrderReport _report;

		private bool _isLoading;

		#region form controls

		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpReportType;
		private System.Windows.Forms.GroupBox grpReportSortOrder;
		private System.Windows.Forms.RadioButton rdoSummaryReport;
		private System.Windows.Forms.RadioButton rdoHistoryReport;
		private System.Windows.Forms.GroupBox grpPatientOrder;
		private System.Windows.Forms.Label lblPatientOrder;
		private System.Windows.Forms.TextBox txtPatientOrder;
		private System.Windows.Forms.Button btnSelectOrder;
		private System.Windows.Forms.RadioButton rdoOrderingLocation;
		private System.Windows.Forms.RadioButton rdoTreatingSpecialty;
		private System.Windows.Forms.GroupBox grpOrderSummaryReport;
		private System.ComponentModel.IContainer components = null;

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgOrderReportCriteria()
		{
			InitializeComponent();

			_report = new BOL.OrderReport();
			_report.Valid += new System.EventHandler(this.CheckValid);
			_report.Invalid += new System.EventHandler(this.CheckValid);
			_report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			_report.SetInitialBrokenRules(this.Name);

			SetComponentProperties();
		}

		#endregion


		#region Properties

		/// <summary>
		/// Get OrderReport
		/// </summary>
		public BOL.OrderReport OrderReport
		{
			get
			{
				return _report;
			}
		}
	
		#endregion


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgOrderReportCriteria));
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpReportType = new System.Windows.Forms.GroupBox();
			this.rdoSummaryReport = new System.Windows.Forms.RadioButton();
			this.rdoHistoryReport = new System.Windows.Forms.RadioButton();
			this.grpPatientOrder = new System.Windows.Forms.GroupBox();
			this.btnSelectOrder = new System.Windows.Forms.Button();
			this.txtPatientOrder = new System.Windows.Forms.TextBox();
			this.lblPatientOrder = new System.Windows.Forms.Label();
			this.grpOrderSummaryReport = new System.Windows.Forms.GroupBox();
			this.grpReportSortOrder = new System.Windows.Forms.GroupBox();
			this.rdoOrderingLocation = new System.Windows.Forms.RadioButton();
			this.rdoTreatingSpecialty = new System.Windows.Forms.RadioButton();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpReportType.SuspendLayout();
			this.grpPatientOrder.SuspendLayout();
			this.grpOrderSummaryReport.SuspendLayout();
			this.grpReportSortOrder.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(432, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Order History Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 401);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 248);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(368, 124);
			this.grpReportCompilation.TabIndex = 1;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(352, 76);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(248, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(248, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(272, 377);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(352, 377);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 341);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(8, 20);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(336, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(228, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 5, 26, 0, 0, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 5, 26, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// grpReportType
			// 
			this.grpReportType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportType.Controls.Add(this.rdoSummaryReport);
			this.grpReportType.Controls.Add(this.rdoHistoryReport);
			this.grpReportType.Controls.Add(this.grpPatientOrder);
			this.grpReportType.Controls.Add(this.grpOrderSummaryReport);
			this.grpReportType.Location = new System.Drawing.Point(60, 32);
			this.grpReportType.Name = "grpReportType";
			this.grpReportType.Size = new System.Drawing.Size(368, 212);
			this.grpReportType.TabIndex = 0;
			this.grpReportType.TabStop = false;
			this.grpReportType.Text = "Report Type*";
			// 
			// rdoSummaryReport
			// 
			this.rdoSummaryReport.Checked = true;
			this.rdoSummaryReport.Location = new System.Drawing.Point(12, 16);
			this.rdoSummaryReport.Name = "rdoSummaryReport";
			this.rdoSummaryReport.Size = new System.Drawing.Size(148, 20);
			this.rdoSummaryReport.TabIndex = 0;
			this.rdoSummaryReport.TabStop = true;
			this.rdoSummaryReport.Text = "O&rder Summary Report";
			this.rdoSummaryReport.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoHistoryReport
			// 
			this.rdoHistoryReport.Location = new System.Drawing.Point(12, 152);
			this.rdoHistoryReport.Name = "rdoHistoryReport";
			this.rdoHistoryReport.Size = new System.Drawing.Size(188, 20);
			this.rdoHistoryReport.TabIndex = 1;
			this.rdoHistoryReport.Text = "Single-Order &History Report";
			this.rdoHistoryReport.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// grpPatientOrder
			// 
			this.grpPatientOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatientOrder.Controls.Add(this.btnSelectOrder);
			this.grpPatientOrder.Controls.Add(this.txtPatientOrder);
			this.grpPatientOrder.Controls.Add(this.lblPatientOrder);
			this.grpPatientOrder.Enabled = false;
			this.grpPatientOrder.Location = new System.Drawing.Point(8, 156);
			this.grpPatientOrder.Name = "grpPatientOrder";
			this.grpPatientOrder.Size = new System.Drawing.Size(352, 48);
			this.grpPatientOrder.TabIndex = 3;
			this.grpPatientOrder.TabStop = false;
			// 
			// btnSelectOrder
			// 
			this.btnSelectOrder.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectOrder.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectOrder.Location = new System.Drawing.Point(324, 20);
			this.btnSelectOrder.Name = "btnSelectOrder";
			this.btnSelectOrder.Size = new System.Drawing.Size(24, 20);
			this.btnSelectOrder.TabIndex = 2;
			this.btnSelectOrder.Text = "find";
			this.btnSelectOrder.Click += new System.EventHandler(this.btnSelectOrder_Click);
			// 
			// txtPatientOrder
			// 
			this.txtPatientOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientOrder.Location = new System.Drawing.Point(84, 20);
			this.txtPatientOrder.Name = "txtPatientOrder";
			this.txtPatientOrder.ReadOnly = true;
			this.txtPatientOrder.Size = new System.Drawing.Size(240, 20);
			this.txtPatientOrder.TabIndex = 1;
			this.txtPatientOrder.TabStop = false;
			this.txtPatientOrder.Text = "";
			// 
			// lblPatientOrder
			// 
			this.lblPatientOrder.Location = new System.Drawing.Point(8, 20);
			this.lblPatientOrder.Name = "lblPatientOrder";
			this.lblPatientOrder.Size = new System.Drawing.Size(76, 20);
			this.lblPatientOrder.TabIndex = 0;
			this.lblPatientOrder.Text = "Patient Order*";
			this.lblPatientOrder.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpOrderSummaryReport
			// 
			this.grpOrderSummaryReport.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpOrderSummaryReport.Controls.Add(this.grpReportSortOrder);
			this.grpOrderSummaryReport.Controls.Add(this.grpDateRange);
			this.grpOrderSummaryReport.Location = new System.Drawing.Point(8, 20);
			this.grpOrderSummaryReport.Name = "grpOrderSummaryReport";
			this.grpOrderSummaryReport.Size = new System.Drawing.Size(352, 128);
			this.grpOrderSummaryReport.TabIndex = 2;
			this.grpOrderSummaryReport.TabStop = false;
			// 
			// grpReportSortOrder
			// 
			this.grpReportSortOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportSortOrder.Controls.Add(this.rdoOrderingLocation);
			this.grpReportSortOrder.Controls.Add(this.rdoTreatingSpecialty);
			this.grpReportSortOrder.Location = new System.Drawing.Point(8, 76);
			this.grpReportSortOrder.Name = "grpReportSortOrder";
			this.grpReportSortOrder.Size = new System.Drawing.Size(336, 44);
			this.grpReportSortOrder.TabIndex = 1;
			this.grpReportSortOrder.TabStop = false;
			this.grpReportSortOrder.Text = "Report Sort Order*";
			// 
			// rdoOrderingLocation
			// 
			this.rdoOrderingLocation.Location = new System.Drawing.Point(176, 16);
			this.rdoOrderingLocation.Name = "rdoOrderingLocation";
			this.rdoOrderingLocation.Size = new System.Drawing.Size(120, 20);
			this.rdoOrderingLocation.TabIndex = 1;
			this.rdoOrderingLocation.Text = "Ordering &Location";
			this.rdoOrderingLocation.CheckedChanged += new System.EventHandler(this.ReportSortOrderChanged);
			// 
			// rdoTreatingSpecialty
			// 
			this.rdoTreatingSpecialty.Checked = true;
			this.rdoTreatingSpecialty.Location = new System.Drawing.Point(12, 16);
			this.rdoTreatingSpecialty.Name = "rdoTreatingSpecialty";
			this.rdoTreatingSpecialty.Size = new System.Drawing.Size(120, 20);
			this.rdoTreatingSpecialty.TabIndex = 0;
			this.rdoTreatingSpecialty.TabStop = true;
			this.rdoTreatingSpecialty.Text = "&Treating Specialty";
			this.rdoTreatingSpecialty.CheckedChanged += new System.EventHandler(this.ReportSortOrderChanged);
			// 
			// DlgOrderReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(432, 417);
			this.Controls.Add(this.grpReportType);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Order_History_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(440, 444);
			this.Name = "DlgOrderReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Order History Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpReportType, 0);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpReportType.ResumeLayout(false);
			this.grpPatientOrder.ResumeLayout(false);
			this.grpOrderSummaryReport.ResumeLayout(false);
			this.grpReportSortOrder.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region methods

		/// <summary>
		/// Sets the initial properties for the components on the form
		/// BR_77.01
		/// </summary>
		private void SetComponentProperties()
		{
			this._isLoading = true;

			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");


			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC086.DlgOrderReportCriteria());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";

			// set date controls
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			// BR_77.01
			this.dtpEndDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpEndDate.MinDate = this.dtpStartDate.Value;

			// BR_77.01
			this.dtpStartDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpStartDate.MaxDate = this.dtpEndDate.Value;

			this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);
			this.dtpPrintDate.MinDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);
		
			// load printer combobox
			foreach (string printerName in BOL.DivisionAlerts.GetPrinters())
			{
				this.cmbPrinterName.Items.Add(printerName);
			}

			this._isLoading = false;
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._report.IsValid);
		
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(this.Name));
			}
		}


		#endregion


		#region events

		#region dates

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				if (this.dtpStartDate.Value > this.dtpEndDate.Value)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC082.StartDateError());
					this.dtpStartDate.Value = this.dtpEndDate.Value;
				}
				this.dtpEndDate.MinDate = this.dtpStartDate.Value;

				_report.StartDate = this.dtpStartDate.Value;
			}
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.dtpEndDate.Value < this.dtpStartDate.Value)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC082.EndDateError());
					this.dtpEndDate.Value = this.dtpStartDate.Value;
				}
				this.dtpStartDate.MaxDate = this.dtpEndDate.Value;

				_report.EndDate = this.dtpEndDate.Value;
			}
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			_report.PrintDate = this.dtpPrintDate.Value;
		}

		#endregion

		#region radio button clicks

		/// <summary>
		/// Report type changed
		/// BR_86.02
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReportTypeChanged(object sender, System.EventArgs e)
		{
			//RadioButton rB = (RadioButton) sender;
			//if (rB.Checked)
			if (((RadioButton) sender).Checked)
			{
				if (this.rdoHistoryReport.Checked)
				{
					_report.IsSingleOrderReport = true;
					this.grpDateRange.Enabled = false;
					this.grpPatientOrder.Enabled = true;
					this.grpReportSortOrder.Enabled = false;

					// This is called 2x for some reason.  This prevents the form from launching twice
					DlgSelectPatientOrder dlg = new DlgSelectPatientOrder(_report);
					if (this.txtPatientOrder.Text.Trim().Length == 0 && dlg.ShowDialog(this) == DialogResult.OK)
					{
						this.txtPatientOrder.Text = dlg.CprsOrderNumber;
					}
				}
				else
				{
					_report.IsSingleOrderReport = false;
					this.grpDateRange.Enabled = true;
					this.grpPatientOrder.Enabled = false;
					this.grpReportSortOrder.Enabled = true;
				}
			}
		}

		/// <summary>
		/// Report sort order changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReportSortOrderChanged(object sender, System.EventArgs e)
		{
			if (this.rdoTreatingSpecialty.Checked) 
			{
				_report.SortByTreatingSpecialty = true;
			}
			else 
			{
				_report.SortByTreatingSpecialty = false;
			}
		}

		/// <summary>
		/// Report compilation changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			if (this.rdoScheduleJob.Checked)
			{
				_report.IsScheduled = true;
				this.grpScheduleJob.Enabled = true;
			}
			else
			{
				_report.IsScheduled = false;
				this.grpScheduleJob.Enabled = false;
			}
		}

		private DataSet GetReportDataSet()
		{
			return new DataSet("Report");
		}

		#endregion

		#region button clicks

		/// <summary>
		/// Launch screen to search for orders
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSelectOrder_Click(object sender, System.EventArgs e)
		{
			DlgSelectPatientOrder dlg = new DlgSelectPatientOrder(_report);
			if (dlg.ShowDialog(this) == DialogResult.OK)
			{
				this.txtPatientOrder.Text = dlg.CprsOrderNumber;
			}
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			// Reusing UC49 code.
			if (_report.IsScheduled)
			{
				// Set this to something other than OK so the report viewer isn't launched.
				this.DialogResult = DialogResult.Cancel;

				if (!_report.IsScheduledReportGreaterThanThirtyDays ||
					(_report.IsScheduledReportGreaterThanThirtyDays && DialogResult.Yes == GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays())))
				{
					_report.Schedule();
				}
			}
			else
			{
				int count = _report.RecordCount;
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					// Set this to something other than OK so the report viewer isn't launched.
					this.DialogResult = DialogResult.Cancel;
				}
				else if((count/25)>=50) //assuming 25 records per page
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result != DialogResult.Yes )
					{
						this.DialogResult = DialogResult.Cancel;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
						this.DialogResult = DialogResult.OK;
					}
				}
			}
			
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion

		#endregion		


	}
}

